
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Add New Support Ticket')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card overflow-hidden">
                <div class="site-card-header">
                    <h3 class="title"> <?php echo e($ticket->title.' - '.$ticket->uuid); ?> <span
                            class="site-badge badge-success"><?php echo e(__('Opened')); ?></span></h3>
                    <div class="card-header-links">
                        <a href="<?php echo e(route('user.ticket.close.now',$ticket->uuid)); ?>"
                           class="card-header-link rounded-pill"><?php echo e(__('Mark it close')); ?></a>
                    </div>
                </div>

                <div class="site-card-body">
                    <div class="support-ticket-single-message user">
                        <div class="logo">
                            <img class="avatar" src="<?php echo e(asset($ticket->user->avatar ?? 'global/materials/user.png')); ?>"
                                 alt="" height="40" width="40">
                        </div>
                        <div class="message-body">
                            <?php echo $ticket->message; ?>

                        </div>


                        <div class="message-footer">
                            <div class="name"><?php echo e($user->full_name); ?></div>
                            <div class="email"><a href="mailto:"><?php echo e($user->email); ?></a></div>
                        </div>
                        <div class="message-attachments">
                            <div class="title"><?php echo e(__('Attachments')); ?></div>
                            <div class="single-attachment">

                                <div class="attach">
                                    <a href="<?php echo e(asset($ticket->attach)); ?>" target="_blank"><i
                                            class="anticon anticon-picture"></i><?php echo e(substr($ticket->attach,14)); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php $__currentLoopData = $ticket->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div
                            class="support-ticket-single-message  <?php if($message->model == 'admin'): ?> admin <?php else: ?> user <?php endif; ?> ">
                            <div class="logo">

                                <?php if( $message->model != 'admin'): ?>
                                    <img class="avatar  avatar-round"
                                         src="<?php echo e(asset($ticket->user->avatar ?? 'global/materials/user.png' )); ?>" alt=""
                                         height="40" width="40">
                                <?php else: ?>
                                    <img class="avatar  avatar-round"
                                         src="<?php echo e(asset($message->user->avatar ?? 'global/materials/user.png' )); ?>" alt=""
                                         height="40" width="40">
                                <?php endif; ?>
                            </div>
                            <div class="message-body">
                                <div class="article">
                                    <?php echo $message->message; ?>

                                </div>
                            </div>
                            <div class="message-footer">
                                <?php if($message->model != 'admin'): ?>
                                <div class="name"><?php echo e($user->full_name); ?></div>
                                <div class="email"><a href="mailto:"><?php echo e($user->email); ?></a></div>
                                <?php else: ?>
                                    <div class="name"><?php echo e($message->user->name); ?></div>
                                <?php endif; ?>
                            </div>
                            <?php if($message->attach): ?>
                                <div class="message-attachments">
                                    <div class="title"><?php echo e(__('Attachments')); ?></div>
                                    <div class="single-attachment">
                                        <div class="attach">
                                            <a href="<?php echo e(asset($message->attach)); ?>" target="_blank"><i
                                                    class="anticon anticon-picture"></i><?php echo e(substr($message->attach,14)); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>
            </div>
            <div class="site-card">
                <div class="site-card-body">
                    <div class="progress-steps-form">
                        <form action="<?php echo e(route('user.ticket.reply')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <input type="hidden" name="uuid" value="<?php echo e($ticket->uuid); ?>">
                            <div class="row mb-3">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                    <div class="wrap-custom-file">
                                        <input
                                            type="file"
                                            name="attach"
                                            id="attach"
                                            accept=".gif, .jpg, .png"
                                        />
                                        <label for="attach">
                                            <img
                                                class="upload-icon"
                                                src="<?php echo e(asset('global/materials/upload.svg')); ?>"
                                                alt=""
                                            />
                                            <span><?php echo e(__('Attach Image')); ?></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-xl-12 col-md-12">
                                    <div class="input-group">
                                        <textarea class="form-control textarea" placeholder="Write Replay"
                                                  name="message"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="buttons">
                                <button type="submit" class="site-btn blue-btn">
                                    <?php echo e(__('Submit')); ?><i class="anticon anticon-double-right"></i>
                                </button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amerimindingwayx/public_html/login/app/Providers/../../resources/views/frontend/default/ticket/show.blade.php ENDPATH**/ ?>