
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Create Role')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Update Role')); ?></h2>
                            <a href="<?php echo e(url()->previous()); ?>" class="title-btn"><i
                                    icon-name="corner-down-left"></i><?php echo e(__('Back')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="row">
                                <form action="<?php echo e(route('admin.roles.update',$role->id)); ?>" method="post">
                                    <?php echo method_field('PUT'); ?>
                                    <?php echo csrf_field(); ?>
                                    <div class="col-xl-12">
                                        <div class="site-input-groups">
                                            <label for="" class="box-input-label"><?php echo e(__('Role Name')); ?></label>
                                            <input type="text" class="box-input" required="" name="name"
                                                   value="<?php echo e($role->name); ?>"/>
                                        </div>
                                    </div>
                                    <div class="col-xl-12">
                                        <div class="site-card">
                                            <div class="site-card-header">
                                                <h3 class="title mb-0"><?php echo e(__('All Permissions')); ?></h3>
                                            </div>
                                            <div class="site-card-body">
                                                <div class="row">
                                                    <div class="col-xl-12">
                                                        <div class="role-cat-items">
                                                            <div class="accordion">
                                                                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                                    <?php
                                                                        $checked = !empty(array_intersect($rolePermissions, $permission->pluck('id')->toArray()));
                                                                    ?>

                                                                    <div class="accordion-item">
                                                                        <h2 class="accordion-header" id="headingOne">
                                                                            <button
                                                                                class="accordion-button <?php if(!$checked): ?> collapsed <?php endif; ?>"
                                                                                type="button" data-bs-toggle="collapse"
                                                                                data-bs-target="#<?php echo e(str_replace(' ','',$category)); ?>"
                                                                                aria-expanded="true"
                                                                                aria-controls="<?php echo e($category); ?>">
                                                                                <span class="icon"><i
                                                                                        icon-name="check"></i></span><?php echo e($category); ?>

                                                                            </button>
                                                                        </h2>
                                                                        <div id="<?php echo e(str_replace(' ','',$category)); ?>"
                                                                             class="accordion-collapse collapse <?php if($checked): ?> show <?php endif; ?>"
                                                                             aria-labelledby="headingOne">
                                                                            <div class="accordion-body">
                                                                                <div class="row">
                                                                                    <?php $__currentLoopData = $permission; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                        <div
                                                                                            class="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                                                                                            <div
                                                                                                class="form-check form-switch role-permission-switch">
                                                                                                <label
                                                                                                    class="switch-label"
                                                                                                    for="<?php echo e($raw->name); ?>"><?php echo e(ucwords(str_replace('-', ' ', $raw->name))); ?></label>
                                                                                                <input
                                                                                                    class="form-check-input big"
                                                                                                    type="checkbox"
                                                                                                    role="switch"
                                                                                                    id="<?php echo e($raw->name); ?>"
                                                                                                    name="permission[]"
                                                                                                    value="<?php echo e($raw->id); ?>"
                                                                                                    <?php if(in_array($raw->id, $rolePermissions)): ?> checked <?php endif; ?>
                                                                                                />
                                                                                            </div>
                                                                                        </div>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-12">
                                                        <button class="site-btn primary-btn" type="submit"><i
                                                                icon-name="check"></i><?php echo e(__('Save Changes')); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amerimindingwayx/public_html/login/resources/views/backend/roles/edit.blade.php ENDPATH**/ ?>