<div class="row">
    <div class="col-xl-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('Recent Transactions')); ?></h3>
            </div>
            <div class="site-card-body table-responsive">
                <div class="site-datatable">
                    <table class="display data-table">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Description')); ?></th>
                            <th><?php echo e(__('Transactions ID')); ?></th>
                            <th><?php echo e(__('Type')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Fee')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Gateway')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <div class="table-description">
                                        <div class="icon">
                                            <i icon-name="<?php switch($transaction->type->value):
                                            case ('send_money'): ?>arrow-right
                                            <?php break; ?>
                                            <?php case ('receive_money'): ?>arrow-left
                                            <?php break; ?>
                                            <?php case ('deposit'): ?>arrow-down-left
                                            <?php break; ?>
                                            <?php case ('investment'): ?>arrow-left-right
                                            <?php break; ?>
                                            <?php case ('withdraw'): ?>arrow-up-left
                                            <?php break; ?>
                                            <?php default: ?>backpack
                                         <?php endswitch; ?>">
                                            </i>
                                        </div>


                                        <div class="description">
                                            <strong><?php echo e($transaction->description); ?> <?php if(!in_array($transaction->approval_cause,['none',""])): ?>
                                                    <span class="optional-msg" data-bs-toggle="tooltip" title=""
                                                          data-bs-original-title="<?php echo e($transaction->approval_cause); ?>"><i
                                                            icon-name="mail"></i></span>
                                                <?php endif; ?>
                                            </strong>
                                            <div class="date"><?php echo e($transaction->created_at); ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td><strong><?php echo e($transaction->tnx); ?></strong></td>
                                <td>
                                    <div
                                        class="site-badge primary-bg"><?php echo e(ucfirst(str_replace('_',' ',$transaction->type->value ))); ?></div>
                                </td>

                                <td><strong
                                        class="<?php echo e(txn_type($transaction->type->value,['green-color','red-color'])); ?>"><?php echo e(txn_type($transaction->type->value,['+','-']) .$transaction->amount.' '.$currency); ?></strong>
                                </td>
                                <td><strong><?php echo e($transaction->charge.' '. $currency); ?></strong></td>
                                <td>


                                    <?php if($transaction->status->value == \App\Enums\TxnStatus::Pending->value): ?>
                                        <div class="site-badge warnning"><?php echo e(__('Pending')); ?></div>
                                    <?php elseif($transaction->status->value ==  \App\Enums\TxnStatus::Success->value): ?>
                                        <div class="site-badge success"><?php echo e(__('Success')); ?></div>
                                    <?php elseif($transaction->status->value ==  \App\Enums\TxnStatus::Failed->value): ?>
                                        <div class="site-badge primary-bg"><?php echo e(__('canceled')); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td><strong><?php echo e($transaction->method); ?></strong></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        <?php if($recentTransactions->isEmpty()): ?>
                            <tr class="centered">
                                <td colspan="7"><?php echo e(__('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/amerimindingwayx/public_html/login/app/Providers/../../resources/views/frontend/default/user/include/__recent_transaction.blade.php ENDPATH**/ ?>