<?php use App\Enums\TxnStatus; ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Schema Logs')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <?php if(!$isMobile): ?>
            <div class="col-xl-12">
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title"><?php echo e(__('All Transactions')); ?></h3>
                    </div>
                    <div class="site-card-body">
                        <div class="site-table">
                            <div class="table-filter">
                                <div class="filter">
                                    <form action="<?php echo e(route('user.transactions')); ?>" method="get">
                                        <div class="search">
                                            <input type="text" id="search" placeholder="Search"
                                                   value="<?php echo e(request('query')); ?>"
                                                   name="query"/>
                                            <input type="date" name="date" value="<?php echo e(request()->get('date')); ?>"/>
                                            <button type="submit" class="apply-btn"><i
                                                    icon-name="search"></i><?php echo e(__('Search')); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(__('Description')); ?></th>
                                        <th><?php echo e(__('Transactions ID')); ?></th>
                                        <th><?php echo e(__('Type')); ?></th>
                                        <th><?php echo e(__('Amount')); ?></th>
                                        <th><?php echo e(__('Fee')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Method')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="table-description">
                                                    <div class="icon">
                                                        <i icon-name="<?php switch($transaction->type->value):
                                                                            case ('send_money'): ?>arrow-right
                                                                            <?php break; ?>
                                                                            <?php case ('receive_money'): ?>arrow-left
                                                                            <?php break; ?>
                                                                            <?php case ('deposit'): ?>arrow-down-left
                                                                            <?php break; ?>
                                                                            <?php case ('manual_deposit'): ?>arrow-down-left
                                                                            <?php break; ?>
                                                                            <?php case ('investment'): ?>arrow-left-right
                                                                            <?php break; ?>
                                                                            <?php case ('withdraw'): ?>arrow-up-left
                                                                            <?php break; ?>
                                                                            <?php default: ?>backpack
                                                                        <?php endswitch; ?>">
                                                        </i>
                                                    </div>
                                                    <div class="description">
                                                        <strong><?php echo e($transaction->description); ?></strong><?php if(!in_array($transaction->approval_cause,['none',""])): ?>
                                                            <span class="optional-msg" data-bs-toggle="tooltip" title=""
                                                                  data-bs-original-title="<?php echo e($transaction->approval_cause); ?>"><i
                                                                    icon-name="mail"></i></span>
                                                        <?php endif; ?>
                                                        <div class="date"><?php echo e($transaction->created_at); ?></div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><strong><?php echo e($transaction->tnx); ?></strong></td>
                                            <td>
                                                <div
                                                    class="site-badge primary-bg"><?php echo e(str_replace('_',' ',$transaction->type->value)); ?></div>
                                            </td>
                                            <td><strong
                                                    class="<?php echo e($transaction->type !== 'subtract' && $transaction->type !== 'investment' && $transaction->type !== 'send_money' && $transaction->type !== 'withdraw' ? 'green-color': 'red-color'); ?>"><?php echo e(($transaction->type !== 'subtract' && $transaction->type !== 'investment' && $transaction->type !== 'send_money' && $transaction->type !== 'withdraw' ? '+': '-' ).$transaction->amount.' '.$transaction->currency); ?></strong>
                                            </td>
                                            <td><strong><?php echo e($transaction->charge); ?> <?php echo e($currency); ?></strong></td>
                                            <td>
                                                <?php switch($transaction->status->value):
                                                    case ('pending'): ?>
                                                        <div class="site-badge warnning"><?php echo e(__('Pending')); ?></div>
                                                        <?php break; ?>
                                                    <?php case ('success'): ?>
                                                        <div class="site-badge success"><?php echo e(__('Success')); ?></div>
                                                        <?php break; ?>
                                                    <?php case ('failed'): ?>
                                                        <div class="site-badge primary-bg"><?php echo e(__('canceled')); ?></div>
                                                        <?php break; ?>
                                                <?php endswitch; ?>
                                            </td>
                                            <td><strong><?php echo e(ucfirst($transaction->method)); ?></strong></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <?php echo e($transactions->links()); ?>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        <?php else: ?>
            <div class="col-12">
                <!-- Transactions -->
                <div class="all-feature-mobile mobile-transactions mb-3">
                    <div class="title"><?php echo e(__('All Transactions')); ?></div>
                    <div class="mobile-transaction-filter">
                        <div class="filter">
                            <form action="<?php echo e(route('user.transactions')); ?>" method="get">
                                <div class="search">

                                    <input type="text" placeholder="Search" value="<?php echo e(request('query')); ?>"
                                           name="query"/>
                                    <input type="date" name="date" value="<?php echo e(request()->get('date')); ?>"/>
                                    <button type="submit" class="apply-btn"><i icon-name="search"></i></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="contents">
                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single-transaction">
                                <div class="transaction-left">
                                    <div class="transaction-des">
                                        <div class="transaction-title"><?php echo e($transaction->description); ?>

                                        </div>
                                        <div class="transaction-id"><?php echo e($transaction->tnx); ?></div>
                                        <div class="transaction-date"><?php echo e($transaction->created_at); ?></div>
                                    </div>
                                </div>
                                <div class="transaction-right">
                                    <div
                                        class="transaction-amount <?php echo e(txn_type($transaction->type->value,['add','sub'])); ?>">
                                        <?php echo e(txn_type($transaction->type->value,['+','-']).$transaction->amount .' '.$currency); ?></div>
                                    <div class="transaction-fee sub">
                                        -<?php echo e($transaction->charge.' '. $currency .' '.__('Fee')); ?> </div>
                                    <div class="transaction-gateway"><?php echo e($transaction->method); ?></div>


                                    <?php if($transaction->status->value == App\Enums\TxnStatus::Pending->value): ?>
                                        <div class="transaction-status pending"><?php echo e(__('Pending')); ?></div>
                                    <?php elseif($transaction->status->value ==  App\Enums\TxnStatus::Success->value): ?>
                                        <div class="transaction-status success"><?php echo e(__('Success')); ?></div>
                                    <?php elseif($transaction->status->value ==  App\Enums\TxnStatus::Failed->value): ?>
                                        <div class="transaction-status canceled"><?php echo e(__('canceled')); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php echo e($transactions->onEachSide(1)->links()); ?>

                </div>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/amerimindingwayx/public_html/login/app/Providers/../../resources/views/frontend/default/user/transaction/index.blade.php ENDPATH**/ ?>