<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
    <div class="site-card">
        <div class="site-card-header">
            <h3 class="title"><?php echo e(__('2FA Security')); ?></h3>
        </div>
        <div class="site-card-body">

            <?php if( null != $user->google2fa_secret): ?>

                <div class="progress-steps-form">
                    <p><?php echo e(__('Two Factor Authentication (2FA) Strengthens Access Security By Requiring Two Methods (also Referred To As Factors) To Verify Your Identity. Two Factor Authentication Protects Against Phishing, Social Engineering And Password Brute Force Attacks And Secures Your Logins From Attackers Exploiting Weak Or Stolen Credentials.')); ?></p>
                    <p><?php echo e(__('Scane the QR code with you Google Authenticator App')); ?></p>

                    <?php
                        $google2fa = (new \PragmaRX\Google2FAQRCode\Google2FA());

                        $inlineUrl = $google2fa->getQRCodeInline(
                           setting('site_title','global'),
                            $user->email,
                            $user->google2fa_secret
                        );
                    ?>



                    <img src="<?php echo e($inlineUrl); ?>">

                    <p class="pt-2">
                        <?php if($user->two_fa): ?>
                            <?php echo e(__('Enter Your Password')); ?>

                        <?php else: ?>
                            <?php echo e(__('Enter the PIN from Google Authenticator App')); ?>

                        <?php endif; ?>
                    </p>

                    <form action="<?php echo e(route('user.setting.action-2fa')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="input-group">
                            <input type="password" name="one_time_password" class="form-control">
                        </div>
                        <div class="buttons mt-4">
                            <?php if($user->two_fa): ?>
                                <button type="submit" class="site-btn blue-btn" value="disable"
                                        name="status"><?php echo e(__('Disable 2FA')); ?><i
                                        class="anticon anticon-double-right"></i></button>
                            <?php else: ?>
                                <button type="submit" class="site-btn blue-btn" value="enable"
                                        name="status"><?php echo e(__('Enable 2FA')); ?><i class="anticon anticon-double-right"></i>
                                </button>
                            <?php endif; ?>
                        </div>

                    </form>

                </div>

            <?php else: ?>
                <a href="<?php echo e(route('user.setting.2fa')); ?>"
                   class="site-btn blue-btn"><?php echo e(__('Obtaining a Secret Key for Two-Factor Authentication')); ?></a>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home/amerimindingwayx/public_html/login/app/Providers/../../resources/views/frontend/default/user/setting/include/__two_fa.blade.php ENDPATH**/ ?>