<?php $__env->startSection('title'); ?>
    <?php echo e(__('Investments')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('All Investments')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body table-responsive">
                            <div class="site-datatable">
                                <table id="dataTable" class="display data-table">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(__('Icon')); ?></th>
                                        <th><?php echo e(__('User')); ?></th>
                                        <th><?php echo e(__('Schema')); ?></th>
                                        <th><?php echo e(__('ROI')); ?></th>
                                        <th><?php echo e(__('Profit')); ?></th>
                                        <th><?php echo e(__('Capital Back')); ?></th>
                                        <th><?php echo e(__('Period Remaining')); ?></th>
                                        <th><?php echo e(__('Timeline')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function ($) {
            "use strict";
            var table = $('#dataTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "<?php echo e(route('admin.investments')); ?>",
                columns: [
                    {data: 'icon', name: 'icon'},
                    {data: 'username', name: 'username'},
                    {data: 'schema', name: 'schema'},
                    {data: 'rio', name: 'rio'},
                    {data: 'profit', name: 'profit'},
                    {data: 'capital_back', name: 'capital_back'},
                    {data: 'period_remaining', name: 'period_remaining'},
                    {data: 'next_profit_time', name: 'next_profit_time'},
                ]
            });


        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amerimindingwayx/public_html/login/resources/views/backend/investment/index.blade.php ENDPATH**/ ?>