
<?php $__env->startSection('title'); ?>
    <?php echo e(__('KYC')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-xl-8 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('KYC')); ?></h3>
                </div>

                <div class="site-card-body">
                    <?php if($user->kyc == \App\Enums\KYCStatus::Pending->value): ?>
                        <div class="site-badge warnning"> <?php echo e(__('Your Kyc Is Pending')); ?></div>
                    <?php elseif($user->kyc == \App\Enums\KYCStatus::Verified->value): ?>
                        <div class="site-badge success"> <?php echo e(__('Your Kyc Is Verified')); ?> </div>
                    <?php else: ?>
                        <form action="<?php echo e(route('user.kyc.submit')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="col-xl-12 col-md-12">
                                <div class="progress-steps-form">
                                    <label for="exampleFormControlInput1"
                                           class="form-label"><?php echo e(__('Verification Type')); ?></label>
                                    <div class="input-group">
                                        <select name="kyc_id" id="kycTypeSelect" class="site-nice-select" required>
                                            <option selected disabled>----</option>
                                            <?php $__currentLoopData = $kycs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kyc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($kyc->id); ?>"><?php echo e($kyc->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>
                                    </div>
                                </div>

                            </div>

                            <div class="col-xl-12 col-md-12">
                                <div class="row kycData">
                                </div>
                            </div>

                            <button type="submit" class="site-btn blue-btn mt-3"><?php echo e(__('Submit Now')); ?></button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $("#kycTypeSelect").on('change',function (e) {
            "use strict"
            e.preventDefault();

            $('.kycData').empty();

            var id = $(this).val();

            var url = '<?php echo e(route("user.kyc.data",":id")); ?>';
            url = url.replace(':id', id);
            $.get(url, function (data) {

                console.log(data);
                $('.kycData').append(data)
                imagePreview()

            });


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/amerimindingwayx/public_html/login/app/Providers/../../resources/views/frontend/default/user/kyc/index.blade.php ENDPATH**/ ?>